/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class CreateColonyMessage
implements IMessage {
    BlockPos townHall;
    boolean claim;
    String colonyName;

    public CreateColonyMessage() {
    }

    public CreateColonyMessage(BlockPos townHall, boolean claim, String colonyName) {
        this.townHall = townHall;
        this.claim = claim;
        this.colonyName = colonyName;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.townHall);
        buf.writeBoolean(this.claim);
        buf.m_130070_(this.colonyName);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.townHall = buf.m_130135_();
        this.claim = buf.readBoolean();
        this.colonyName = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer sender = ctxIn.getSender();
        Level world = ctxIn.getSender().f_19853_;
        if (sender == null) {
            return;
        }
        if (sender.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)ModItems.supplyChest)) <= 0 && !sender.m_7500_() && !this.claim) {
            MessageUtils.format("com.minecolonies.coremod.supplyneed", new Object[0]).sendTo(new Player[]{sender});
            return;
        }
        IColony colony = IColonyManager.getInstance().getClosestColony(world, this.townHall);
        String style = "wooden";
        BlockEntity tileEntity = world.m_7702_(this.townHall);
        if (!(tileEntity instanceof TileEntityColonyBuilding)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.create.notileentity", new Object[0]).with(ChatFormatting.BOLD, ChatFormatting.DARK_RED).sendTo(new Player[]{sender});
            return;
        }
        TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
        if (!hut.getStyle().isEmpty()) {
            style = hut.getStyle();
        } else if (((List)hut.getPositionedTags().getOrDefault(BlockPos.f_121853_, new ArrayList())).contains("deactivated")) {
            hut.reactivate();
        }
        if (((Boolean)MineColonies.getConfig().getServer().restrictColonyPlacement.get()).booleanValue()) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(this.townHall, ((ServerLevel)world).m_8900_()));
            if (spawnDistance < (double)((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue()) {
                if (!world.f_46443_) {
                    MessageUtils.format("com.minecolonies.coremod.tooclose", MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).sendTo(new Player[]{sender});
                }
                return;
            }
            if (spawnDistance > (double)((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).intValue()) {
                if (!world.f_46443_) {
                    MessageUtils.format("com.minecolonies.coremod.toofar", MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).sendTo(new Player[]{sender});
                }
                return;
            }
        }
        if (colony != null && !IColonyManager.getInstance().isFarEnoughFromColonies(world, this.townHall)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.denied.tooclose", colony.getName()).sendTo(new Player[]{sender});
            return;
        }
        IColony ownedColony = IColonyManager.getInstance().getIColonyByOwner(world, (Player)sender);
        if (ownedColony == null) {
            IColonyManager.getInstance().createColony(world, this.townHall, (Player)sender, this.colonyName, style);
            IColonyManager.getInstance().getIColonyByOwner(world, (Player)sender).getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, world);
            MessageUtils.format("com.minecolonies.coremod.progress.colony_founded", new Object[0]).with(ChatFormatting.GOLD).sendTo(new Player[]{sender});
            return;
        }
        MessageUtils.format("com.minecolonies.coremod.gui.colony.create.failed", new Object[0]).with(ChatFormatting.BOLD, ChatFormatting.DARK_RED).sendTo(new Player[]{sender});
    }
}

